	function X = EQ_P_PARAM_Z(Pap, Nap)
	
	% 	Convert allpass poles to optimization parameters, X.
	% 	Used in EQ_TG_LP_Z

	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, 2010-10-11
    % 	Modified by:		 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1	
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	 % Convert poles to real parameters, X.
	 
	Pap = cplxpair(Pap);
	for n = 1:2:Nap-mod(Nap, 2)
		rtwo = abs(Pap(n))^2;
		X(n) = -rtwo;
		X(n+1) = 2*real(Pap(n))/(1+rtwo);
	end
	if mod(Nap,2) == 1
		X(Nap) = Pap(Nap);
	end
	return
